<?php
require("MySQLDAO.php");
require("../Classes/EmailConfirmation.php");
$config = parse_ini_file('../config/config.ini');


$returnValue = array();

if(  empty ($_REQUEST["user_first_name"])  || empty($_REQUEST["user_last_name"]) 
        || empty($_REQUEST["user_email"]) || empty($_REQUEST["user_phone"]) 
        || empty($_REQUEST["user_password"])  )
{
    $returnValue["status"]="400";
    $returnValue["message"]="Missing required information";
    echo json_encode($returnValue);
    return;
}

$userFirstName = htmlentities($_REQUEST["user_first_name"]);
$userLastName = htmlentities($_REQUEST["user_last_name"]);
$userEmail = htmlentities($_REQUEST["user_email"]);
$userPhone = htmlentities($_REQUEST["user_phone"]);
$userPassword  = htmlentities($_REQUEST["user_password"]);
$isEmailConfirmed = 0 ;
$type = 'normal' ; 
$image ='image' ;
// $salt = openssl_random_pseudo_bytes(16);
$salt =  2017*(hexdec(bin2hex(openssl_random_pseudo_bytes(16))));
$secured_password = sha1($userPassword . $salt);

$dbhost = trim($config["dbhost"]);
$dbuser = trim($config["dbuser"]);
$dbpassword = trim($config["dbpassword"]);
$dbname = trim($config["dbname"]);

$dao = new MySQLDAO($dbhost, $dbuser, $dbpassword, $dbname);
$dao->openConnection();
$userDetails = $dao->getUserDetails($userEmail);

if(!empty($userDetails))
{
    $returnValue["status"]="400";
    $returnValue["message"]="Please choose a different email address"; 
    echo json_encode($returnValue);
    return;
}
$result =$dao->registerUser( $userFirstName , $userLastName , $userEmail  , $userPhone, $secured_password , $salt ,$image ,$isEmailConfirmed , $type );
if($result)  
{
    $userDetails = $dao->getUserDetails($userEmail);
    $returnValue["status"]="200";  
    $returnValue["user_id"] = $userDetails["user_id"];
    $returnValue["first_name"] = $userDetails["first_name"];
    $returnValue["last_name"] = $userDetails["last_name"];
	$returnValue["email"] = $userDetails["email"];
	$returnValue["phone_number"] = $userDetails["mobile_number"]; 
	$returnValue["is_confirmed"] = $userDetails["isEmailConfirmed"];
	$returnValue["type"] = $userDetails["user_type"];
	$returnValue["image"] = $userDetails["user_image"];
 	
	$emailConfirmation = new EmailConfirmation();
    $emailToken = $emailConfirmation->generateUniqueToken(16);
    
    $dao->storeEmailToken($userDetails["user_id"], $emailToken);
    
    $messageDetails = array();
    $messageDetails["message_subject"] = "Please confirm your email address";
    $messageDetails["to_email"] = $userDetails["email"];
    $messageDetails["from_name"] = "khwarizmi consulting team";
    $messageDetails["from_email"] = "ahmed.said@khwarizm.com";
    
    $emailMessage = $emailConfirmation->loadEmailEmailMessage();  // from html
    $emailMessage = str_replace("{token}", $emailToken, $emailMessage);
    $messageDetails["message_body"] = $emailMessage;
    
    $emailConfirmation->sendEmailConfirmation($messageDetails);



    
} else {
    $returnValue["status"]="400";
    $returnValue["message"]="Could not register user with provided information"; 
}

$dao->closeConnection();

echo json_encode($returnValue);


?>
